<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="mnlno"></xsl:variable>
<xsl:template match="/">
	<a name='top'></a>
	<table border="0">
		<tr>
			<th align='left' style='font-size:9pt;'>Model Name:</th>
			<td><span id='modelno' style='font-size:9pt;'></span></td>
		</tr>
		<tr>
			<th align='left' style='font-size:9pt;'>Manual No.:</th>
			<td style='font-size:9pt;'><xsl:value-of select='$mnlno'/></td>
		</tr>
	</table>
	<form name='form1' action='mailto:?subject=Parts Order' method='post' enctype='text/plain'>
		<table border="1" cellspacing="0" cellpadding="3" width="100%" bordercolordark="#FFFFFF" bordercolor="#777777" id="tbl">
			<tr height='24' style='color:captiontext;' bgcolor='activecaption'>
				<th colspan='7'>
					<div align='left'>
						PARTS BASKET
					</div>
				</th>
			</tr>
			<tr height='23' bgcolor='threedface'>
				<th>NO.</th>
				<th>REF</th>
				<th>PARTS NO.</th>
				<th>PARTS NAME</th>
				<th>BLOCK</th>
				<th>QTY</th>
				<th>ACTION</th>
			</tr>
			<xsl:apply-templates select="//ROW">
			</xsl:apply-templates>
		</table>
		<a name='bottom'></a>
		<table border='0' width='100%'>
			<tr>
				<td align='right'>
					<a href="#top">↑top</a>
				</td>
			</tr>
		</table>
		<table border="0" align="center" cellspacing="5">
			<tr>
				<td>
					<input type='button' id='mailbtn' value='Mailto' onclick='mailOrder();'/>
				</td>
				<td>
					<input type='button' id='btn' value='Print Screen' onClick='window.print();'/>
				</td>
				<td>
					<input type='button' id='btn' value='Clear' onClick='clearParts();'/>
				</td>
				<td>
					<input type='button' id='btn' value='Close' onClick='window.close();'/>
				</td>
			</tr>
		</table>
	</form>
</xsl:template>

<xsl:template match="/PARTSORDER/ROW">
	<tr height='23'>
		<td align="center" nowrap="nowrap">
			<xsl:value-of select="position()"/>
		</td>
		<td nowrap="nowrap">
			<xsl:if test="SYMBOL[. != '']"><xsl:value-of select="SYMBOL"/></xsl:if>
			<xsl:if test="SYMBOL[. = '']"><br/></xsl:if>
		</td>
		<td width="150" nowrap="nowrap">
			<xsl:if test="PART_NO[. != '']"><xsl:value-of select="PART_NO"/></xsl:if>
			<xsl:if test="PART_NO[. = '']"><br/></xsl:if>
		</td>
		<td width="150" nowrap="nowrap">
			<xsl:if test="PART_NAME[. != '']"><xsl:value-of select="PART_NAME"/></xsl:if>
			<xsl:if test="PART_NAME[. = '']"><br/></xsl:if>
		</td>
		<td width="10" nowrap="nowrap">
			<xsl:if test="BLOCK_NO[. != '']"><xsl:value-of select="BLOCK_NO"/></xsl:if>
			<xsl:if test="BLOCK_NO[. = '']"><br/></xsl:if>
		</td>
		<td width="10" nowrap="nowrap">
			<input type="text" id="qty" size="1" maxlength="5" onkeypress="toNum()">
				<xsl:attribute name="value">
					<xsl:value-of select="ORDERQTY"/>
				</xsl:attribute>
				<xsl:attribute name="onblur">
					setValue('<xsl:value-of select="@NO"/>',this)
				</xsl:attribute>
			</input>
		</td>
		<td width="10" nowrap="nowrap">
			<input type="button" id="rmvBtn" value="Delete">
				<xsl:attribute name="onClick">
					removeParts('<xsl:value-of select="@NO"/>')
				</xsl:attribute>
			</input>
		</td>
	</tr>
</xsl:template>

</xsl:stylesheet>
